<?php

class Idbeauty_Axelis_ImportstocksController extends Mage_Core_Controller_Front_Action
{

    public function indexAction()
    {

        Idbeauty_Axelis_Model_Axelis::checkKey();

        Mage::log('*Import des stocks', null, 'axelis.log');

        //Récupération des fichiers de stock
        $filenames=$this->retrievefiles();

        //Traitement de chaque fichier un par un
        foreach($filenames as $filename) {

            //Ouverture du fichier
            $content = $this->openStockFile($filename);

            //Pour chaque ligne produit
            foreach ($content as $stock) {

//                echo $this->getProductId($stock) . " ".$this->getQty($stock)."<br>";
                $this->updateStock($stock);
                //          $orders = Mage::getResourceModel('sales/order');

            }


        } die();
    }
    public function openStockfile($filename)
    {
        ini_set("auto_detect_line_endings", true);
        if(substr($filename,-4)=='.csv'){
        $f = fopen("var" . DIRECTORY_SEPARATOR . "archivesaxelis" . DIRECTORY_SEPARATOR . "recus".DIRECTORY_SEPARATOR."stocks" . DIRECTORY_SEPARATOR . $filename, 'r');
        if($f!==FALSE) {
            $i = 0;
            while (($csv = fgetcsv($f, 4096, ";")) !== FALSE) {

                if ($i > 0) {
                    $line[] = $csv;
                }
                $i++;
            }
            return $line;
        }}
    }


    public function retrievefiles()
    {

        $files= Idbeauty_Axelis_Model_Axelis::ftplistfiles("/In/Stocks");
        foreach($files as $file){

            $filepart=explode("/",$file);
            $filename=$filepart[(sizeof($filepart)-1)];
            $filenames[]=$filename;
            Idbeauty_Axelis_Model_Axelis::ftpdownloadfile($file,"var" . DIRECTORY_SEPARATOR . "archivesaxelis" . DIRECTORY_SEPARATOR . "recus".DIRECTORY_SEPARATOR."stocks" . DIRECTORY_SEPARATOR . $filename);

        }
        return $filenames;
    }



    public function getProductId($stock){
        return $stock[5];
    }
    public function getQty($stock){
        return $stock[10];
    }



    public function updateStock($stock){


        // Check if SKU exists
        $sku=$this->getProductId($stock);
        $product = Mage::getModel('catalog/product')->loadByAttribute('sku',$sku);

        if ( $product ) {

            $productId = $product->getId();
            $stockItem = Mage::getModel('cataloginventory/stock_item')->loadByProduct($productId);
            $stockItemId = $stockItem->getId();

            if (!$stockItemId) {
                $stockItem->setData('product_id', $product->getId());
                $stockItem->setData('stock_id', 1);
            } else {
                $existingstockdata = $stockItem->getData();
            }
                $stockItem->setData('qty',$this->getQty($stock));


            $stockItem->save();


            unset($stockItem);
            unset($product);

            Mage::log('Nouveau Stock '.$sku.' '.$product->getName().' : '.$this->getQty($stock), null, 'axelis.log');

            echo "<br />Stock updated $sku";

        }else{

            Mage::log('*Erreur import stock : Produit'.$sku.' non trouvé', null, 'axelis.log');

        }

    }



}




