<?php
/**
 * Copyright © 2016 Magentix. All rights reserved.
 *
 * NOTICE OF LICENSE
 * This source file is subject to commercial licence, do not copy or distribute without authorization
 */

class LaPoste_Colissimo_Block_Adminhtml_Source_Country extends Mage_Adminhtml_Block_Abstract
{

    /**
     * @var string
     */
    protected $_template = 'colissimo/source/country.phtml';

    /**
     * @var string
     */
    protected $_model = 'laposte_colissimo/system_country';

    /**
     * Retrieve countries
     *
     * @return array
     */
    public function getCountries()
    {
        /** @var LaPoste_Colissimo_Model_System_Country $model */
        $model = Mage::getModel($this->_model);

        return $model->toOptionArray();
    }

    /**
     * Set specific country model
     *
     * @param string $model
     */
    public function setModel($model)
    {
        $this->_model = $model;
    }

}