<?php
/**
 * Copyright © 2016 Magentix. All rights reserved.
 *
 * NOTICE OF LICENSE
 * This source file is subject to commercial licence, do not copy or distribute without authorization
 */

class LaPoste_Colissimo_Block_Frontend_Colissimo_Method extends LaPoste_Colissimo_Block_Frontend_Colissimo
{

    /**
     * Retrieve Method Controller URL
     *
     * @return string
     */
    public function getControllerUrl()
    {
        return $this->getUrl('colissimo/method/', array('_secure' => $this->isSecure()));
    }

    /**
     * Retrieve method JS
     *
     * @param string $script
     * @return string
     */
    public function getMethodJs($script)
    {
        return $this->getSkinUrl('colissimo/method/' . $script, array('_secure' => $this->isSecure()));
    }

}