<?php
/**
 * Copyright © 2016 Magentix. All rights reserved.
 *
 * NOTICE OF LICENSE
 * This source file is subject to commercial licence, do not copy or distribute without authorization
 */

class LaPoste_Colissimo_Block_Frontend_Colissimo_Pickup extends LaPoste_Colissimo_Block_Frontend_Colissimo
{

    /**
     * Retrieve Pickup Controller URL
     *
     * @return string
     */
    public function getControllerUrl()
    {
        return $this->getUrl('colissimo/pickup/', array('_secure' => $this->isSecure()));
    }

    /**
     * Retrieve if map must be shown
     *
     * @return int
     */
    public function getShowMap()
    {
        /** @var LaPoste_Colissimo_Helper_Data $helper */
        $helper = Mage::helper('laposte_colissimo');

        return $helper->canShowMap();
    }

    /**
     * Retrieve Google Api Key
     *
     * @return string
     */
    public function getMapApiKey()
    {
        /** @var LaPoste_Colissimo_Helper_Data $helper */
        $helper = Mage::helper('laposte_colissimo');

        return $helper->getMapApiKey();
    }

    /**
     * Retrieve skin JS Url
     *
     * @return string
     */
    public function getSkinJs()
    {
        return $this->getBaseSkinUrl('js/script.js');
    }

    /**
     * Retrieve skin CSS Url
     *
     * @return string
     */
    public function getSkinCss()
    {
        return $this->getBaseSkinUrl('css/style.css');
    }

    /**
     * Retrieve base skin URL
     *
     * @param string $file
     * @return string
     */
    public function getBaseSkinUrl($file)
    {
        /** @var LaPoste_Colissimo_Helper_Data $helper */
        $helper = Mage::helper('laposte_colissimo');
        $skinData = $helper->getSkinData();

        $skinUrl = '';

        if (isset($skinData['skin'])) {
            $skinUrl = $this->getSkinUrl(
                $skinData['skin'] . '/' . $file, array('_secure' => $this->isSecure())
            );
        }

        return $skinUrl;
    }

}