<?php
/**
 * Copyright © 2016 Magentix. All rights reserved.
 *
 * NOTICE OF LICENSE
 * This source file is subject to commercial licence, do not copy or distribute without authorization
 */

class LaPoste_Colissimo_Model_Method extends Varien_Object
{

    /**
     * Save shipping Address
     *
     * @param Varien_object $request
     * @return array|bool
     */
    public function saveAddress($request)
    {
        /** @var LaPoste_Colissimo_Helper_Data $helper */
        $helper = Mage::helper('laposte_colissimo');

        $address = $request->getAddress();

        /* Update telephone */
        $telephone = $request->getTelephone();
        $telephone = $helper->getTelephone(
            preg_replace('/[^0-9+]/', '', $telephone), $address->getCountryId(), 'add'
        );
        $address->setTelephone($telephone);

        /* Update Product code */
        list($carrierCode, $method) = explode('_', $request->getShippingMethod(), 2);
        $signatureType = $helper->getSignatureType($carrierCode);
        $path = $carrierCode . '/country/' . $address->getCountryId() . '/type/' . $signatureType;
        $code = $helper->getConfig($path);
        if ($code) {
            $address->setColissimoProductCode($code);
        }

        /* Save address */
        $address->save();

        /* Valid telephone */
        if (!$helper->isValidMobileNumber($address->getTelephone(), $address->getCountryId())) {
            $example = $helper->getConfig(
                'country_settings/' . $address->getCountryId() . '/phone_example'
            );
            return array(
                'success' => false,
                'error'   => true,
                'message' => $helper->__(
                    'Please enter a valid mobile phone number. Example: %s', $example
                )
            );
        }

        return true;
    }

}