<?php

class MGS_Mpanel_Adminhtml_InstallController extends Mage_Adminhtml_Controller_Action
{

	public function indexAction() {
		$params = $this->getRequest()->getParams();
		
		//Save theme config 
		$this->saveThemeConfig($params);
		
		//Import require static block
		$filePath = Mage::getBaseDir() . '/app/code/local/MGS/Mpanel/data/themes/' . $params['theme'] . '/theme_static.xml';
		
		$filePath1 = Mage::getBaseDir() . '/app/code/local/MGS/Mpanel/data/themes/' . $params['theme'] . '/default_config.xml';
		
		if (is_readable($filePath))
		{
			$config = new Varien_Simplexml_Config($filePath);
			try{
				foreach ($config->getNode('item') as $child)
				{
					$collection = Mage::getModel('cms/block')->getCollection()
						->addFieldToFilter('identifier', $child->identifier)
						->load();
					
					if (count($collection) > 0){
						foreach ($collection as $_item)
							$_item->delete();
					}
					
					Mage::getModel('cms/block')
						->setTitle($child->title)
						->setIdentifier($child->identifier)
						->setContent($child->content)
						->setIsActive(1)
						->setStores(array(0))
						->save();
				}
				Mage::getSingleton('adminhtml/session')->addSuccess(Mage::helper('mpanel')->__('%s theme was successfully installed.', $params['theme']));
				
				//if(Mage::getStoreConfig('mgs_theme/install/data_demo')){
					$this->installDataDemo($params['theme']);
				//}
			}catch(Exception $e){
				Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
			}
		}else{
			Mage::getSingleton('adminhtml/session')->addError(Mage::helper('mpanel')->__('Can not install %s theme.', $params['theme']));
		}
		
		if (is_readable($filePath1))
		{
			$config1 = new Varien_Simplexml_Config($filePath1);
			
			try{
				foreach ($config1->getNode('section') as $child1)
				{
					$arrConfig = json_decode(json_encode($child1), true);
					foreach($arrConfig as $section=>$data){
						$this->saveSettings($section, $data);
					}
				}
			}catch(Exception $e){
				Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
			}
		}
		
		
		$this->_redirectReferer();
        return;
	}
	
	public function restoreAction(){
		$params = $this->getRequest()->getParams();
		
		$filePath = Mage::getBaseDir() . '/app/code/local/MGS/Mpanel/data/themes/' . $params['theme'] . '/default_config.xml';
		if (is_readable($filePath))
		{
			$config = new Varien_Simplexml_Config($filePath);
			
			try{
				foreach ($config->getNode('section') as $child)
				{
					$arrConfig = json_decode(json_encode($child), true);
					foreach($arrConfig as $section=>$data){
						$this->saveSettings($section, $data);
					}
				}
			}catch(Exception $e){
				Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
			}
		}else{
			Mage::getSingleton('adminhtml/session')->addError(Mage::helper('mpanel')->__('Can not restore default theme configuration.'));
		}
		$this->_redirectReferer();
        return;
	}
	
	// Save settings
	public function saveSettings($section, $data){
		$config = new Mage_Core_Model_Config();
		foreach($data as $group=>$_group){
			foreach($_group as $field=>$value){
				$config->saveConfig($section.'/'.$group.'/'.$field, $value);
			}
		}
	}
	
	public function saveThemeConfig($data){
		$groups = array();
		$groups['package']['fields']['name']['value'] = 'mgstheme';
		$groups['theme']['fields']['default']['value'] = $data['theme'];
		
		$section = 'design';
		$website = $this->getRequest()->getParam('website');
		$store   = $this->getRequest()->getParam('store');
		Mage::getSingleton('adminhtml/config_data')
			->setSection($section)
			->setWebsite($website)
			->setStore($store)
			->setGroups($groups)
			->save();
		
		$groups1 = array();
		$groups1['general']['fields']['enabled']['value'] = 1;
		
		$section1 = 'mpanel';
		Mage::getSingleton('adminhtml/config_data')
			->setSection($section1)
			->setWebsite($website)
			->setStore($store)
			->setGroups($groups1)
			->save();
	}
	
	public function installDataDemo($theme){
		// Install cms page demo
		$filePath = Mage::getBaseDir() . '/app/code/local/MGS/Mpanel/data/themes/' . $theme . '/cms_page.xml';
		if (is_readable($filePath))
		{
			$config = new Varien_Simplexml_Config($filePath);
			try{
				foreach($config->getNode('item') as $child)
				{
					$collection = Mage::getModel('cms/page')->getCollection()
						->addFieldToFilter('identifier', $child->identifier)
						->load();
					
					if (count($collection) > 0){
						foreach ($collection as $_item)
							$_item->delete();
					}
					
					Mage::getModel('cms/page')
						->setTitle($child->title)
						->setIdentifier($child->identifier)
						->setIsActive(1)
						->setContentHeading($child->content_heading)
						->setRootTemplate($child->root_template)
						->setContent($child->content)
						->setStores(array(0))
						->save();
				}
			}catch(Exception $e){
				
			}
		}
		
		// Install theme layout demo data
		$filePath = Mage::getBaseDir() . '/app/code/local/MGS/Mpanel/data/themes/' . $theme . '/theme_layout.xml';
		if (is_readable($filePath))
		{
			$config = new Varien_Simplexml_Config($filePath);
			try{
				foreach($config->getNode('item') as $child)
				{
					$collection = Mage::getModel('mpanel/layout')->getCollection()
						->addFieldToFilter('page_type', $child->page_type)
						->addFieldToFilter('identifier', $child->indentifier)
						->load();
					
					if (count($collection) > 0){
						foreach ($collection as $_item)
							$_item->delete();
					}
					
					Mage::getModel('mpanel/layout')
						->setPageType($child->page_type)
						->setIndentifier($child->indentifier)
						->setLeft($child->left)
						->setRight($child->right)
						->save();
				}
			}catch(Exception $e){
				
			}
		}
	}
}