<?php

class MGS_Deals_Block_Adminhtml_Deals_Edit_Tab_Form extends Mage_Adminhtml_Block_Widget_Form
{
  protected function _prepareForm()
  {
      $form = new Varien_Data_Form();
      $this->setForm($form);
      $fieldset = $form->addFieldset('deals_form', array('legend'=>Mage::helper('deals')->__('Item information')));
     
      $fieldset->addField('title', 'text', array(
          'label'     => Mage::helper('deals')->__('Title'),
          'class'     => 'required-entry',
          'required'  => true,
          'name'      => 'title',
      ));

      $fieldset->addField('filename', 'file', array(
          'label'     => Mage::helper('deals')->__('File'),
          'required'  => false,
          'name'      => 'filename',
	  ));
		
      $fieldset->addField('status', 'select', array(
          'label'     => Mage::helper('deals')->__('Status'),
          'name'      => 'status',
          'values'    => array(
              array(
                  'value'     => 1,
                  'label'     => Mage::helper('deals')->__('Enabled'),
              ),

              array(
                  'value'     => 2,
                  'label'     => Mage::helper('deals')->__('Disabled'),
              ),
          ),
      ));
     
      $fieldset->addField('content', 'editor', array(
          'name'      => 'content',
          'label'     => Mage::helper('deals')->__('Content'),
          'title'     => Mage::helper('deals')->__('Content'),
          'style'     => 'width:700px; height:500px;',
          'wysiwyg'   => false,
          'required'  => true,
      ));
     
      if ( Mage::getSingleton('adminhtml/session')->getDealsData() )
      {
          $form->setValues(Mage::getSingleton('adminhtml/session')->getDealsData());
          Mage::getSingleton('adminhtml/session')->setDealsData(null);
      } elseif ( Mage::registry('deals_data') ) {
          $form->setValues(Mage::registry('deals_data')->getData());
      }
      return parent::_prepareForm();
  }
}