<?php

class Potato_AddressAutocomplete_Model_Source_Name_Type
{
    const LONG_NAME_CODE = 'long_name';
    const LONG_NAME_LABEL = 'Long Name';

    const SHORT_NAME_CODE = 'short_name';
    const SHORT_NAME_LABEL = 'Short Name';

    public function toOptionArray()
    {
        $helper = Mage::helper('po_addressautocomplete');
        return array(
            array(
                'value' => self::LONG_NAME_CODE,
                'label' => $helper->__(self::LONG_NAME_LABEL),
            ),
            array(
                'value' => self::SHORT_NAME_CODE,
                'label' => $helper->__(self::SHORT_NAME_LABEL),
            ),
        );
    }

    /**
     * @return array
     */
    public function toArray()
    {
        $helper = Mage::helper('po_addressautocomplete');
        return array(
            self::LONG_NAME_CODE  => $helper->__(self::LONG_NAME_LABEL),
            self::SHORT_NAME_CODE => $helper->__(self::SHORT_NAME_LABEL),
        );
    }
}