/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
-----------------------------------------------------*/

/* check file type and size for video upload */
function checkVideoFile(element,maxSize){
	videoSizeConfig = parseFloat(maxSize);
	videoUpload = element.files[0];
	videoName = videoUpload.name;
	videoSize = videoUpload.size;
	videoType = videoUpload.type;

	if(videoSize > (1048576*videoSizeConfig)){
		alert(videoName+' is to big. Thumbnai maximum is '+videoSizeConfig+' mb');
		$j(element).replaceWith($j(element).val('').clone(true));
		return false;
	}
	else if(videoType != 'video/mp4' && videoType != 'video/x-flv' && videoType != 'video/flv' && videoType != 'video/mpeg'){
		if(videoType === ''){
			pos = videoName.lastIndexOf('.');
			if (pos !== -1 && (videoName.substr(pos)==='.flv' || videoName.substr(pos)==='.mp4' || videoName.substr(pos)==='.mpg')){
				return true;
			}
		}
		alert(videoName+' doesnt match mp4 or flv or mpg');
		$j(element).replaceWith($j(element).val('').clone(true));
		return false;
	}
	return true;
}

/* check file type and size for thumbnail upload */
function checkThumbnailFile(element,maxSize){
	thumbnailSizeConfig = parseFloat(maxSize);
	thumbnail = element.files[0];
	thumbnailName = thumbnail.name;
	thumbnailSize = thumbnail.size;
	thumbnailType = thumbnail.type;
	if(thumbnailSize > (1048576*thumbnailSizeConfig)) {
		alert(thumbnailName+' is to big. Thumbnail maximum is '+thumbnailSizeConfig+' mb');
		$j(element).replaceWith($j(element).val('').clone(true));
		return false;
	}
	else if(thumbnailType != 'image/png' && thumbnailType != 'image/jpg' && thumbnailType != 'image/gif' && thumbnailType != 'image/jpeg' ) {
		if(thumbnailType === ''){
			pos = thumbnailType.lastIndexOf('.');
			if (pos !== -1 && (thumbnailName.substr(pos)==='.png' || thumbnailName.substr(pos)==='.gif' || thumbnailName.substr(pos)==='.jpg' || thumbnailName.substr(pos)==='.jpeg')){
				return true;
			}
		}
		alert(thumbnailName+' doesnt match png, jpg or gif');
		$j(element).replaceWith($j(element).val('').clone(true));
		return false;
	}
	return true;
}

/* check thumbnail update type & size */
function checkUpdateThumbnail(element,maxSize){
	if(checkThumbnailFile(element,maxSize)){
		$j(element).next('input.gridlist-thumbnail-file-upload-clone').val($j(element).val());
	}
}

/* update thumbnail ajax */
function updateThumbnail(vid,url,element,defaultStr){
	if($j(element).prev('input.gridlist-thumbnail-file-upload-clone').val()!=='' && $j(element).prev('input.gridlist-thumbnail-file-upload-clone').val()!==defaultStr){
		var thumbnailUpdateForm = new FormData();
		thumbnailUpdateForm.append('vid', vid);
		thumbnailUpdateForm.append('video-thumbnail', $j('#gridlist-thumbnail-file-upload-'+vid)[0].files[0]);
		$j.ajax({
			type: 'POST',
			url: url,
			data: thumbnailUpdateForm,
			enctype: 'multipart/form-data',
			contentType: false,
			processData: false,
			beforeSend: function(){
				$j('#loading-mask').css('display','block');
			},
			success: function(data) {
			},
			complete: function(data) {
				$j('#loading-mask').css('display','none');
				var responseData = $j.parseJSON(data.responseText);
				if(responseData.error){
					alert(responseData.error);
				}else{
					if(responseData.newthumbnail){
						$j('img#gridlist-thumbnail-image-'+vid).attr('src',responseData.newthumbnail);
					}
					$j(element).prev('input.gridlist-thumbnail-file-upload-clone').val(defaultStr);
				}
			},
			error:function(response){
				alert(response.responseText);
			}
		});
	}else{
		alert('Please select thumbnail image');
		$j('#gridlist-thumbnail-file-upload-'+vid).trigger('click');
	}
}

/* delete video ajax */
function deleteVideo(vid,url){
	var deleteConfirm = confirm('You want delete this video?');
	if(deleteConfirm){
		$j.ajax({
			type: 'POST',
			url: url,
			data: {'vid':vid},
			beforeSend: function(){
				$j('#loading-mask').css('display','block');
			},
			success: function(data) {
			},
			complete: function(data) {
				$j('#loading-mask').css('display','none');
				var responseData = $j.parseJSON(data.responseText);
				if(responseData.error){
					alert(responseData.error);
				}else{
					$j('tr#gridlist-video-row-'+vid).remove();
					if($j('tbody#cmsmart-product-video-content').children('tr[id^="gridlist-video-row-"]').length<1){
						$j('tbody#cmsmart-product-video-content').html('<tr><td colspan="7" class="a-center">There are no video matching for this product.</td></tr>');
					}
				}
			},
			error:function(response){
				alert(response.responseText);
			}
		});
	}
}

/* update video data ajax */
function updateVideoData(vid,url,element,cell){
	postData = {};
	switch($j(element).attr('type')){
		case 'text':
			postData = {'vid':vid,'column':cell,'value':$j(element).val()};
			break;
		case 'checkbox':
			postData = {'vid':vid,'column':cell,'value':$j(element).prop('checked')};
			break;
	}
	$j.ajax({
		type: 'POST',
		url: url,
		data: postData,
		beforeSend: function(){
			$j('#loading-mask').css('display','block');
		},
		success: function(data) {
		},
		complete: function(data) {
			$j('#loading-mask').css('display','none');
			var responseData = $j.parseJSON(data.responseText);
			if(responseData.error){
				alert(responseData.error);
			}else{
				if(responseData.newdata){
					/*alert(responseData.newdata);*/
				}
			}
		},
		error:function(response){
			alert(response.responseText);
		}
	});
}

/* add new video ajax */
function addVideo(url,type){
	var videoDataForm = new FormData();
	videoDataForm.append('product-id', $j('#cmsmart-productvideo-pid').val());
	videoDataForm.append('action-type', type);
	if(type==='add'){
		videoDataForm.append('video-thumbnail', $j('#add-video-thumbnail')[0].files[0]);
		videoDataForm.append('video-url', $j('#add-video-url').val());
		videoDataForm.append('video-name', $j('#add-video-name').val());
		videoDataForm.append('video-order', $j('#add-video-sort-order').val());
		videoDataForm.append('video-exclude', $j('#add-video-exclude').prop('checked'));
	}else{
		videoDataForm.append('video-thumbnail', $j('#upload-video-thumbnail')[0].files[0]);
		videoDataForm.append('video-file', $j('#upload-video-file')[0].files[0]);
		videoDataForm.append('video-name', $j('#upload-video-name').val());
		videoDataForm.append('video-order', $j('#upload-video-sort-order').val());
		videoDataForm.append('video-exclude', $j('#upload-video-exclude').prop('checked'));
	}
	$j.ajax({
		type: 'POST',
		url: url,
		data: videoDataForm,
		enctype: 'multipart/form-data',
		contentType: false,
		processData: false,
		beforeSend: function(){
			$j('#loading-mask').css('display','block');
		},
		success: function(data) {
		},
		complete: function(data) {
			$j('#loading-mask').css('display','none');
			var responseData = $j.parseJSON(data.responseText);
			if(responseData.error){
				alert(responseData.error);
			}else{
				if($j('tbody#cmsmart-product-video-content').children('tr[id^="gridlist-video-row-"]').length<1){
					$j('tbody#cmsmart-product-video-content').html('');
				}
				$j('tbody#cmsmart-product-video-content').append(responseData.tbodytr);
				$j('#add-video-content input').val('');
				$j('#upload-video-content input').val('');
				$j('#add-video-thumbnail').replaceWith($j('#add-video-thumbnail').clone(true));
				
				if(responseData.type_upload == "youtube"){
					if(responseData.url_authorization != null){
						showCmsmartPopup(responseData.url_authorization, 500, 400);
					} else {
						var msg = 'This video has been uploaded successfully!\n';
						msg += 'Please access: https://www.youtube.com/watch?v='+responseData.video_id;
						alert(msg);
					}
				}
			}
		},
		error:function(response){
			alert(response.responseText);
		}
	});
}

function showCmsmartPopup(url, width, height){
    var screenX = typeof window.screenX != 'undefined' ? window.screenX : window.screenLeft;
    var screenY = typeof window.screenY != 'undefined' ? window.screenY : window.screenTop;
    var outerWidth = typeof window.outerWidth != 'undefined' ? window.outerWidth : document.body.clientWidth;
    var outerHeight = typeof window.outerHeight != 'undefined' ? window.outerHeight : (document.body.clientHeight - 22);
    var left = parseInt(screenX + ((outerWidth - width) / 2), 10);
    var top = parseInt(screenY + ((outerHeight - height) / 2.5), 10);
    var settings = (
        'width=' + width +
            ',height=' + height +
            ',left=' + left +
            ',top=' + top
        );
    var newwindow = window.open(url, '', settings);
    return false;
}
