/*------------------------------------
* Product Video Extention
* Author  CMSMart Team
* Copyright Copyright (C) 2012 http://cmsmart.net. All Rights Reserved.
* @license - http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL
* Websites: http://cmsmart.net
* Email: team@cmsmart.net
* Technical Support: http://cmsmart.net/support_ticket/
* Forum - http://cmsmart.net/forum
-----------------------------------------------------*/
/* Image Slider */
$j(document).ready(function(){
	$j('.productvideo-image-slider-wrapper').each(function(index){
		wrapperEle = $j(this);
		rootEle = wrapperEle.children('.productvideo-image-slider');
		itemEle = rootEle.children();
		
		widthSlide = itemEle.outerWidth(true)*itemEle.length;
		
		if(wrapperEle.width()<widthSlide){
			rootEle.css('width',widthSlide+'px');
			wrapperEle.next('.productvideo-image-slider-button').css('display','inline-block');
			wrapperEle.prev('.productvideo-image-slider-button').css('display','inline-block');
		}
	});
});
function imageSliderBackButton(element,speedEffect){
	currentButton = $j(element);
	wrapperEle = currentButton.next('.productvideo-image-slider-wrapper');
	sliderCotent = wrapperEle.children('.productvideo-image-slider');
	
	if(!currentButton.hasClass('disable')){
		currentButton.addClass('disable');
		rangeLeft = imageSliderCheckBack(wrapperEle,sliderCotent);
		if(rangeLeft>0){			
			wrapperEle.next('.productvideo-image-slider-button').removeClass('disable');
			sliderCotent.animate({
				left: '+='+rangeLeft,
				},
				1000*speedEffect,
				function(){
					/* Animation complete. */
					if((wrapperEle.offset().left-sliderCotent.offset().left)>0){
						currentButton.removeClass('disable');
					}
				}
			);
		}
	}
}
function imageSliderNextButton(element,speedEffect){
	currentButton = $j(element);
	wrapperEle = currentButton.prev('.productvideo-image-slider-wrapper');
	sliderCotent = wrapperEle.children('.productvideo-image-slider');
	
	if(!currentButton.hasClass('disable')){
		currentButton.addClass('disable');
		rangeRight = imageSliderCheckNext(wrapperEle,sliderCotent);
		if(rangeRight>0){
			wrapperEle.prev('.productvideo-image-slider-button').removeClass('disable');
			sliderCotent.animate({
				left: '-='+rangeRight,
				},
				1000*speedEffect,
				function(){
					/* Animation complete. */
					if((sliderCotent.offset().left+sliderCotent.width())-(wrapperEle.offset().left+wrapperEle.width())>0){
						currentButton.removeClass('disable');
					}
				}
			);
		}
	}
}
function imageSliderCheckBack(wrapperEle,contentEle){
	wrapperPosition = wrapperEle.offset();
	contentPosition = contentEle.offset();
	
	minLeft = wrapperPosition.left;
	leftContentHiddenRange = minLeft - contentPosition.left;
	sliderItemWidth = contentEle.children().outerWidth(true);
	
	if(leftContentHiddenRange > 0){
		if(leftContentHiddenRange > sliderItemWidth){
			return sliderItemWidth;
		}else{
			return leftContentHiddenRange;
		}
	}else{
		return 0;
	}
}
function imageSliderCheckNext(wrapperEle,contentEle){
	wrapperPosition = wrapperEle.offset();
	contentPosition = contentEle.offset();
	
	minLeft = wrapperPosition.left;
	contentLeft = contentPosition.left;
	maxRight = wrapperEle.width() + minLeft;
	contentRight = contentEle.width() + contentLeft;
	rightContentHiddenRange = contentRight - maxRight;
	sliderItemWidth = contentEle.children().outerWidth(true);
	
	if(rightContentHiddenRange > 0){
		if(rightContentHiddenRange > sliderItemWidth){
			return sliderItemWidth;
		}else{
			return rightContentHiddenRange;
		}
	}else{
		return 0;
	}
}
/* End Image Slider */