if (!window.edn2jq)
    throw new Error('jQuery for EDN module is not loaded');

(function ($) {
    window.EDN2Relay = function (config) {
        var debug = function () {
            if (config.debug || window.location.href.match(/edn2jsdebug/)) {
                var args = Array.prototype.slice.call(arguments);
                args.unshift('EDN2Relay');
                console.debug.apply(console, args);
            }
        };

        debug('Constructor');

        // private vars
        var _this = this;
        var _googlemapsInit = false;
        var _infowindow = null;
        var _map = null;
        var _bounds = null;
        var _markers = [];
        var _lastGetRelaysResult = null;

        // private vars from config

        /** @var Object shippingMethods */
        var _shippingMethods = config.shippingMethods;
        var _googleMapApiKey = config.googleMapApiKey;

        var _lang = config.lang || {
            'noRelayAvailable': 'Aucun point relais disponible',
            'Opening hours': 'Heures d\'ouverture',
            'Chosen relay point': 'Point relais choisi :',
            'buttons': {
                'select-relay-point': 'Sélectionner un point relais',
                'choose-relay-point': 'Choisir ce point relais',
                'change-relay-point': 'Sélectionner un autre point relais'
            },
            'days': {
                'monday': 'Lundi',
                'tuesday': 'Mardi',
                'wednesday': 'Mercredi',
                'thursday': 'Jeudi',
                'friday': 'Vendredi',
                'saturday': 'Samedi',
                'sunday': 'Dimanche'
            }
        };

        var _getRelaysUrl = config.getRelaysUrl;
        var _baseUrl = config.baseUrl.replace('index.php/', '') || '/';
        var _imagesPath = _baseUrl + 'skin/frontend/base/default/images/edn2/relays/';

        var _$form = null;
        var _$mapContainer = $(config.mapContainer ||
            '<div id="envoidunetMap">' +
            '   <div id="envoidunetMapInner">' +
            '       <div class="envoidunetClose" title="Fermer la carte"></div>' +
            '       <div id="envoidunetMapContainer">' +
            '           <div id="envoidunetMapCanvas"></div>' +
            '       </div>' +
            '       <div id="envoidunetPrContainer"></div>' +
            '   </div>' +
            '</div>');
        var _$mapCanvas = _$mapContainer.find('#envoidunetMapCanvas');
        var _$mapPrContainer = _$mapContainer.find('#envoidunetPrContainer');

        var $body = $('body');
        $body.append(_$mapContainer);

        $body.delegate('[data-edn2-action=change-relay-point]', 'click', function (e) {
            e.preventDefault();
            show_map($(this).attr('data-edn2-carrier-code') + '_' + $(this).attr('data-edn2-carrier-code'));
        });

        _$mapContainer.delegate('[data-edn2-action=choose-relay-point]', 'click', function (e) {
            e.preventDefault();
            select_relay($(this).attr('data-edn2-carrier-code'), $(this).attr('data-edn2-relay-id'));
        });

        _$mapContainer.delegate('.envoidunetClose', 'click', function (e) {
            close_map();
        });

        _this.googleMapsInitializedCallback = function () {
            _googlemapsInit = true;
        };

        // defer google maps loading to detect other loaded GoogleMaps
        setTimeout(function(){
            load_googlemaps();
        }, 5000);

        var detectShippingForm = function () {
            _$form = $('input[name=shipping_method]').closest('form');
            if (_$form.length && !_$form.find('[data-edn2-status]').length) {
                debug('Shipping form detected');

                init();
            }

            setTimeout(detectShippingForm, 200);
        };

        detectShippingForm();

        function getShippingMethodData(shippingMethod) {
            for (var i = 0; i < _shippingMethods.length; i++) {
                var shippingMethodData = _shippingMethods[i];
                if (shippingMethodData.shippingMethod === shippingMethod) {
                    return shippingMethodData;
                }
            }

            return null;
        }

        function isRelay(shippingMethod) {
            var shippingMethodData = getShippingMethodData(shippingMethod);
            return shippingMethodData && shippingMethodData.isRelay;
        }

        function init() {
            debug('init called');

            _$form.find('input[name=shipping_method]').after('<div data-edn2-status="loaded"></div>');

            _$form.delegate('input[name=shipping_method]', 'change', function () {
                close_map();
            });

            var update_shipping_methods = function() {
                _$form.find('input[name="shipping_method"]').each(function(){
                    // Show the map if a shipping method is already selected
                    $el = $(this);
                    if ($el.is(':checked')) {
                        var shippingMethod = $el.val();
                        var shippingMethodData = getShippingMethodData(shippingMethod);
                        if (isRelay(shippingMethod) && $el.parent().find('.envoidunetChosenRelayPoint').length === 0) {
                            $el.parent().append(
                                $('<div class="envoidunetChosenRelayPoint">' +
                                    '<a href="#" class="envoidunetParcelButton envoidunetPointer" data-edn2-action="change-relay-point" data-edn2-carrier-code="' + shippingMethodData.carrierCode + '">' + _lang['buttons']['select-relay-point'] + '</a>' +
                                    '</div>'
                                )
                            );
                        }
                    } else {
                        $(this).parent().find('.envoidunetChosenRelayPoint').remove();
                    }
                });
            };

            _$form.delegate('input[name="shipping_method"]', 'change', function () {
                update_shipping_methods();

                var shippingMethod = $(this).val();
                if (isRelay(shippingMethod) && $(this).is(':checked')) {
                    show_map(shippingMethod);
                }
            });

            update_shipping_methods();
        }

        function load_googlemaps() {
            debug('load_googlemaps called');

            if (typeof (window.google) !== 'object' || typeof (google.maps) !== 'object') {
                var script = document.createElement('script');
                script.type = 'text/javascript';
                script.src = '//maps.googleapis.com/maps/api/js?v=3' + '&region=FR&language=FR&callback=edn2relay.googleMapsInitializedCallback&key=' + _googleMapApiKey;
                document.body.appendChild(script);
            } else {
                setTimeout(function(){
                    _this.googleMapsInitializedCallback();
                }, 50);
            }
        }

        function show_map(shippingMethod) {
            debug('show_map called');
            _$mapPrContainer.html('');
            _$mapContainer.css('display', 'block');
            // set offset on the middle of the page (or top of the page for small screens)
            var offset = $(window).scrollTop() + ($(window).height() - _$mapContainer.height()) / 2;
            if (offset < $(window).scrollTop()) {
                offset = $(window).scrollTop();
            }
            _$mapContainer.css('top', offset + 'px');
            var options = {
                zoom: 11,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };

            if (!_map && _$mapCanvas.length > 0) {
                _map = new google.maps.Map(_$mapCanvas.get(0), options);
            }
            _bounds = new google.maps.LatLngBounds();

            _infowindow = new google.maps.InfoWindow();
            google.maps.event.trigger(_map, 'resize');

            var shippingMethodData = getShippingMethodData(shippingMethod);

            $.ajax({
                url: _getRelaysUrl,
                data: {carrier: shippingMethodData.carrierCode},
                dataType: 'json',
                timeout: 15000,
                error: error_relays,
                success: function (getRelaysResult) {
                    _lastGetRelaysResult = getRelaysResult;
                    show_relays(shippingMethodData.carrierCode,
                        _lastGetRelaysResult['carriers']
                        && _lastGetRelaysResult['carriers']
                        && _lastGetRelaysResult['carriers'][shippingMethodData.carrierCode]['relays'] ?
                            _lastGetRelaysResult['carriers'][shippingMethodData.carrierCode]['relays'] : []
                    );
                }
            });
            if (typeof $(this).attr("shown") == "undefined") {
                google.maps.event.trigger(_map, 'resize');
            }
        }

        /*
         * Close and clear the google map
         */
        function close_map() {
            debug('close_map called');
            _$mapContainer.css('display', 'none');
            _$mapPrContainer.html('');
            for (var i = 0; i < _markers.length; i++) {
                _markers[i].setMap(null);
            }
            _markers = [];
        }

        /*
         * We update the zoom level to the best fit
         */
        function update_zoom_map() {
            debug('update_zoom_map called');
            // zoom only if we have all markers
            if (parcels.length === 0 || (parcels.length !== 0 && _markers.length < parcels.length)) {
                return;
            }
            var bounds = new google.maps.LatLngBounds();

            for (var i = 0; i < _markers.length; i++) {
                if (typeof _markers[i] != 'undefined') {
                    bounds.extend(_markers[i].getPosition());
                }
            }
            _map.setCenter(bounds.getCenter());
            google.maps.event.addDomListener(window, 'resize', function () {
                _map.setCenter(bounds.getCenter());
            });
            _map.fitBounds(bounds);
            _map.setZoom(_map.getZoom() - 1);
            // if only 1 marker, unzoom
            if (_map.getZoom() > 15) {
                _map.setZoom(15);
            }
            google.maps.event.trigger(_map, 'resize');
        }

        /*
         * Add google map events on a marker
         */
        function add_google_map_events(marker, code) {
            debug('add_google_map_events called');
            // open popup on map click
            google.maps.event.addListener(marker, "click", function () {
                if (typeof openedWindow != 'undefined' && openedWindow !== null) {
                    openedWindow.close();
                }
                openedWindow = _infowindow;
                _infowindow.setContent(this.get("content"));
                _infowindow.open(_map, this);
            });
            // open popup on right column title click
            $(document).delegate(".showInfo" + code, "click", function () {
                if (typeof openedWindow != 'undefined' && openedWindow !== null) {
                    openedWindow.close();
                }
                openedWindow = _infowindow;
                _infowindow.setContent(marker.get("content"));
                _infowindow.open(_map, marker);
            });
        }

        /*
         * Now that we have all the parcel points, we display them
         */
        function show_relays(carrierCode, relays) {
            debug('show_relays called', carrierCode, relays);
            parcels = relays;

            if (relays.length === 0) {
                alert(_lang.noRelayAvailable);
                close_map();
                return;
            }

            // add parcel point markers
            for (var i in relays) {
                // prevents bizarre javascript bug when array has extra prototype function
                if (isNaN(parseInt(i)) || i >= 30) {
                    continue;
                }

                var point = relays[i];
                var name = point.street1;

                var markeridx = parseInt(i) + 1;

                var envoidunetMarker = {
                    url: _imagesPath + '/pin_edn_' + ('00' + markeridx).substring(markeridx.toString().length) + '.png',
                    origin: new google.maps.Point(0, 0),
                    anchor: new google.maps.Point(13, 37),
                    scaledSize: new google.maps.Size(26, 37)
                };

                var latlng = new google.maps.LatLng(parseFloat(point.lat), parseFloat(point.lon));

                var marker = new google.maps.Marker({
                    map: _map,
                    position: latlng,
                    icon: envoidunetMarker,
                    title: name
                });
                marker.set("content", '<div class="envoidunetMakerPopup">' + get_relay_html_block(carrierCode, relays[i], 'choose-relay-point', true) + '</div>');
                _bounds.extend(marker.getPosition());

                add_google_map_events(marker, carrierCode);

                _markers[i] = marker;
                // update zoom
                update_zoom_map();
                //})(i);
            }

            _map.fitBounds(_bounds);

            // add list of points html (in map pop)
            var html = '';
            html += '<table><tbody>';
            for (i in relays) {
                // prevents bizarre javascript bug when array has extra prototype function
                if (isNaN(parseInt(i)) || i >= 30) {
                    continue;
                }

                var markeridx = parseInt(i) + 1;

                var pinUrl = _imagesPath + '/pin_edn_' + ('00' + markeridx).substring(markeridx.toString().length) + '.png';

                point = relays[i];
                html += '<tr>';
                html += '<td><img src="' + pinUrl + '" class="envoidunetMarker" />';
                html += get_relay_html_block(carrierCode, point, 'choose-relay-point', false);
                html += '</td>';
                html += '</tr>';
            }
            html += '</tbody></table>';
            _$mapPrContainer.html(html);


            // remove info if we click on the map
            google.maps.event.addListener(_map, "click", function () {
                _infowindow.close();
            });
        }

        /*
         * We clicked on the "choose this relay point" link on the map popup
         */
        function select_relay(carrierCode, relayId) {
            debug('select_relay called', carrierCode, relayId);

            var relayData = get_selected_relay_data(carrierCode, relayId);

            _$form.find('.envoidunetChosenRelayPoint').remove();

            _$form.find('input[name=shipping_method][value=' + carrierCode + '_' + carrierCode + ']').parent().append(
                $('<div class="envoidunetChosenRelayPoint">'+
                        '<strong>' + _lang['Chosen relay point'] + '</strong><br/>' +
                        get_relay_html_block(carrierCode, relayData, 'change-relay-point', false) +
                        '<input type="hidden" name="envoidunetrelayid" value="' + relayId + '"/>' +
                    '</div>'
                )
            );
            close_map();
        }

        function error_relays(jqXHR, textStatus, errorThrown) {
            alert(_lang['Unable to load relay points'] + ' : ' + errorThrown);
        }

        function get_selected_relay_data(carrierCode, relayId) {
            if(_lastGetRelaysResult && _lastGetRelaysResult['carriers'][carrierCode]) {
                for (var i in _lastGetRelaysResult['carriers'][carrierCode]['relays']) {
                    var relayData = _lastGetRelaysResult['carriers'][carrierCode]['relays'][i];

                    if (relayData['id'] === relayId) {
                        return relayData;
                    }
                }
            }

            return null;
        }

        function get_relay_html_block(carrierCode, relayData, action, showOpeningHours) {
            var html =
                '<div class="envoidunetRelayPointInfo">' +
                '   <strong>' + relayData.street1 + '</strong><br/>' +
                    relayData.street3 + ', ' + relayData.postcode + ' ' + relayData.city + '<br/>';

            if(showOpeningHours) {
                html += '<strong>' + _lang['Opening hours'] + '</strong>' +
                    '<br/>' +
                    '<div class="envoidunetSchedule">';
                for (var d in _lang.days) {
                    var day = relayData[d];
                    if (!day || !day.length) {
                        continue;
                    }

                    html += '<span class="envoidunetDay">' + _lang['days'][d] + '</span>';
                    html += day[0];
                    if (day[1]) {
                        html += "&nbsp;" + day[1]
                    }
                    html += '<br/>';
                }
                html += '</div>';
            }

            if(action) {
                html += '<a href="#" class="envoidunetParcelButton envoidunetPointer" data-edn2-action="' + action + '" data-edn2-carrier-code="' + carrierCode + '" data-edn2-relay-id="' + relayData.id + '">' + _lang['buttons'][action] + '</a>';
            }

            html += '</div>';

            return html;
        }
    };
})(edn2jq);