CodeMirror.runMode = function (string, modespec, callback) {
    var mode = CodeMirror.getMode({indentUnit: 2}, modespec);
    var isNode = callback.nodeType == 1;
    if (isNode) {
        var node = callback, accum = [];
        callback = function (string, style) {
            if (string == "\n")
                accum.push("<br>");
            else if (style)
                accum.push("<span class=\"cm-" + CodeMirror.htmlEscape(style) + "\">" + CodeMirror.htmlEscape(string) + "</span>");
            else
                accum.push(CodeMirror.htmlEscape(string));
        }
    }
    var lines = CodeMirror.splitLines(string), state = CodeMirror.startState(mode);
    for (var i = 0, e = lines.length; i < e; ++i) {
        if (i)
            callback("\n");
        var stream = new CodeMirror.StringStream(lines[i]);
        while (!stream.eol()) {
            var style = mode.token(stream, state);
            callback(stream.current(), style);
            stream.start = stream.pos;
        }
    }
    if (isNode)
        node.innerHTML = accum.join("");
};
