ShippingMethod.addMethods({

    methodInit: function(url) {
        this.MethodController = url;
        this.MethodContainer = 'checkout-shipping-method-load';
        this.MethodActions = {'load':'form'};
    },

    methodLaunch: function() {
        var telephone = $$('input[name=telephone]');

        if (!telephone.length) {
            this.methodRun();
        } else {
            this.methodNext();
        }
    },

    methodRun: function() {
        var shipping = $$('input[name=shipping_method]:checked');
        this.methodLoadContent(this.MethodActions.load, {'shipping_method':shipping.first().value});
    },

    methodLoadContent: function(action, data)
    {
        this.Request = new Ajax.Request(this.MethodController + action, {
            onComplete: function(transport) {
                $(this.MethodContainer).update(transport.responseText);
            }.bind(this),
            onFailure: this.methodFailure(),
            parameters: data
        });
    },

    methodFailure: function()
    {
        checkout.ajaxFailure.bind(checkout)
    },

    methodNext: function()
    {
        checkout.setLoadWaiting('shipping-method');
        new Ajax.Request(
            this.saveUrl, {
                method: 'post',
                onComplete: function() {
                    checkout.setLoadWaiting(false);
                    checkout.reloadStep('shipping');
                },
                onSuccess: this.onSave,
                onFailure: checkout.ajaxFailure.bind(checkout),
                parameters: Form.serialize(this.form)
            }
        );
    },

});